<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Civil Appellate High Court</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

<header id="main-header">
    
    <div class="logo-container">
        <img src="https://upload.wikimedia.org/wikipedia/commons/5/5f/Emblem_of_Sri_Lanka.svg" alt="Emblem of Sri Lanka">
        <div class="logo-text">
            <h1 class="court-name">Civil Appellate High Court</h1>
            <p class="court-sub">of the Democratic Socialist Republic of Sri Lanka</p>
            <div class="logo-divider"></div>
        </div>
    </div>

    <nav id="navbar">
        <ul>
            <li><a href="index.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">Home</a></li>
            
            <li class="dropdown">
                <a href="#">About Us <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="about.php">History & Jurisdiction</a></li>
                    <li><a href="judges.php">Honorable Judges</a></li>
                    <li><a href="past_judges.php">Past Judges</a></li>
                    <li><a href="speeches.php">Ceremonial Speeches</a></li> 
                </ul>
            </li>

            <li class="dropdown">
                <a href="#">Case Registry <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="live_cases.php" style="color:var(--primary-color) !important; font-weight:bold;">Live Display Board</a></li> 
                    <li><a href="daily_list.php">Daily Cause List</a></li>
                    <li><a href="bench_list.php">Bench Constitution</a></li>
                    <li><a href="full_diary.php">Full Court Diary</a></li>
                </ul>
            </li>

            <li class="dropdown">
                <a href="#">Judgments <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="judgments.php">Judgment Archive</a></li>
                    <li><a href="#">Land Acquisition Orders</a></li>
                </ul>
            </li>
            
            <li class="dropdown">
                <a href="#">Litigant Info <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-content">
                    <li><a href="info_citizens.php">Filing Procedures</a></li>
                    <li><a href="#">Certified Copies</a></li>
                    <li><a href="#">Fees & Stamps</a></li>
                </ul>
            </li>
            
            <li><a href="news_notices.php">Notices</a></li>
        </ul>
    </nav>
    
    <div class="header-icons">
        <i class="fas fa-search search-btn"></i>
        <i class="fas fa-bars menu-btn" onclick="toggleSidebar()"></i>
    </div>

</header>

<div class="sidebar" id="mySidebar">
    <div class="close-btn" onclick="toggleSidebar()">&times;</div>
    
    <div class="mobile-nav-links" style="margin-bottom: 30px;">
        <h3>Quick Menu</h3>
        <ul style="display:block;">
            <li class="sidebar-post"><a href="live_cases.php"><i class="fas fa-broadcast-tower"></i> Live Status</a></li>
            <li class="sidebar-post"><a href="daily_list.php"><i class="fas fa-calendar-day"></i> Today's List</a></li>
        </ul>
    </div>

    <h3>Latest Notices</h3>
    <div class="sidebar-post">
        <a href="news_notices.php">Revised Guidelines for Written Submissions in Civil Appeals.</a>
        <span style="font-size:0.8rem; color:#888;">Feb 01, 2026</span>
    </div>
    <div class="sidebar-post">
        <a href="news_notices.php">Court Holiday Notice – Poson Poya</a>
        <span style="font-size:0.8rem; color:#888;">Jan 10, 2026</span>
    </div>

    <h3>Contact Registry</h3>
    <div class="contact-item">
        <i class="fas fa-phone-alt"></i>
        <p>+94 011 243 7500</p>
    </div>
    <div class="contact-item">
        <i class="fas fa-envelope"></i>
        <p>registrar.civil@highcourt.lk</p>
    </div>
    <div class="contact-item">
        <i class="fas fa-map-marker-alt"></i>
        <p>Superior Courts Complex,<br>Colombo 12</p>
    </div>

    <h3>Follow Us</h3>
    <div class="social-links">
        <a href="#" class="social-btn fb"><i class="fab fa-facebook-f"></i></a>
        <a href="#" class="social-btn tw"><i class="fab fa-twitter"></i></a>
    </div>

</div>

<script>
    function toggleSidebar() {
        var sidebar = document.getElementById("mySidebar");
        sidebar.classList.toggle("active");
    }

    // Sticky Header Effect: Changes look when scrolling down
    window.addEventListener("scroll", function(){
        var header = document.querySelector("header");
        header.classList.toggle("sticky", window.scrollY > 0);
    });
</script>